/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import ibm.nways.ras.ErrorLogServerHandle;
import ibm.nways.ras.LogService;
import ibm.nways.ras.MessageLog;
import ibm.nways.ras.RAS;
import ibm.nways.ras.TraceLog;
import java.applet.Applet;
import java.rmi.RemoteException;

public class Traces {
    public static long traceMask;
    public static int logSize;
    public static int maxLogSize;
    private static boolean useNewLogging;
    private static MessageLog mlog;
    private static TraceLog tlog;
    public static final long TRACE_SNMP = 1L;
    public static final long TRACE_PLATFORM = 2L;
    public static final long TRACE_POLLING = 4L;
    public static final long TRACE_JPM_DATABASE = 8L;
    public static final long TRACE_STATUS = 16L;
    public static final long TRACE_DEFINITION = 32L;
    public static final long TRACE_RESOURCE = 64L;
    public static final long TRACE_HUBS_JMA = 128L;
    public static final long TRACE_HUBS_DECODER = 256L;
    public static final long TRACE_HUBS_BRIDGE = 512L;
    public static final long TRACE_8229 = 1024L;
    public static final long TRACE_8230 = 2048L;
    public static final long TRACE_8238 = 4096L;
    public static final long TRACE_8285 = 8192L;
    public static final long TRACE_8275 = 16384L;
    public static final long TRACE_8275d = 32768L;
    public static final long TRACE_8275rr = 65536L;
    public static final long TRACE_8271c = 131072L;
    public static final long TRACE_LSPEED = 262144L;
    public static final long TRACE_8281 = 524288L;
    public static final long TRACE_8282 = 0x100000L;
    public static final long TRACE_2212 = 0x200000L;
    public static final long TRACE_2210 = 0x400000L;
    public static final long TRACE_2216 = 0x800000L;
    public static final long TRACE_8224 = 0x1000000L;
    public static final long TRACE_FREE1 = 0x2000000L;
    public static final long TRACE_8237 = 0x4000000L;
    public static final long TRACE_8239 = 0x8000000L;
    public static final long TRACE_8245 = 0x10000000L;
    public static final long TRACE_FREE2 = 0x20000000L;
    public static final long TRACE_8271k = 0x40000000L;
    public static final long TRACE_8272 = Integer.MIN_VALUE;
    public static final long TRACE_8371 = 0x100000000L;
    public static final long TRACE_NetU = 0x200000000L;
    public static final int VALID_TRACE_FLAGS = 34;
    public static final long FLAG1 = 0x400000000L;
    public static final long FLAG2 = 0x800000000L;
    public static final long FLAG_ALL = -1L;
    public static String[] TRACE_STRINGS;

    public static void initializeTraces(String[] stringArray) throws RemoteException {
        String string = "localhost";
        int n = 2099;
        traceMask = 0L;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string2.equals("-debug")) {
                string2 = stringArray[n2 + 1];
                if (string2.equals("FLAG_ALL")) {
                    traceMask = -1L;
                    ++n2;
                } else if (string2.startsWith("FLAG")) {
                    String string3 = string2.substring(4);
                    try {
                        traceMask |= (long)(1 << Integer.parseInt(string3) - 1);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    ++n2;
                }
            } else if (string2.equals("-servername")) {
                string = stringArray[n2 + 1];
                ++n2;
            } else if (string2.equals("-portnum")) {
                try {
                    n = Integer.parseInt(stringArray[n2 + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 1099;
                }
            }
            ++n2;
        }
        Traces.initialize(string, n);
    }

    public static void initializeTraces(Applet applet) throws RemoteException {
        int n;
        String string = applet.getParameter("debug");
        String string2 = applet.getParameter("port_num");
        traceMask = 0L;
        if (string != null && string.length() > 0) {
            if (string.equals("FLAG_ALL")) {
                traceMask = -1L;
            } else if (string.startsWith("FLAG")) {
                String string3 = string.substring(4);
                try {
                    traceMask |= (long)(1 << Integer.parseInt(string3) - 1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 1099;
        }
        Traces.initialize(applet.getDocumentBase().getHost(), n);
    }

    public static void initializeTraces(String string, int n) throws RemoteException {
        try {
            Traces.initialize(string, n);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void initializeTraces() {
        try {
            Traces.initialize("127.0.0.1", 2099);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void initializeTraces(ErrorLogServerHandle errorLogServerHandle) {
        try {
            Traces.initialize("127.0.0.1", 2099);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void initialize(String string, int n) throws RemoteException {
        traceMask = 0L;
        LogService logService = LogService.getManager(string, n);
        if (logService != null) {
            mlog = logService.getMsgLog(1);
            tlog = logService.getTrcLog(1);
            useNewLogging = true;
        }
    }

    public static boolean isEnabled(long l) {
        return (traceMask & l) != 0L;
    }

    public static void enterStaticMethod(long l, String string) {
        if ((traceMask & l) != 0L) {
            RAS.enter(1, "Traces", string);
        }
    }

    public static void exitStaticMethod(long l, String string) {
        if ((traceMask & l) != 0L) {
            RAS.exit(1, "Traces", string);
        }
    }

    public static void enterMethod(long l, Object object, String string) {
        if ((traceMask & l) != 0L) {
            RAS.enter(1, object, string);
        }
    }

    public static void exitMethod(long l, Object object, String string) {
        if ((traceMask & l) != 0L) {
            RAS.exit(1, object, string);
        }
    }

    public static void traceMessage(long l, String string) {
        if ((traceMask & l) != 0L) {
            RAS.trace(1, mlog, "Traces:traceMessage", string);
        }
    }

    public static void logError(Object object, String string) {
        RAS.logOut(object, "Traces:logError", string);
    }

    public static void logInformation(Object object, String string) {
        RAS.logOut(object, "Traces:logInformation", string);
    }

    public static void logWarning(Object object, String string) {
        RAS.logOut(object, "Traces:logWarning", string);
    }

    public static void logException(Exception exception) {
        RAS.logException(1, "Traces", "logException", exception);
    }

    public static void setTraceStatus(long l) {
        traceMask |= l;
    }

    public static void resetTraceStatus(long l) {
        traceMask &= 0xFFFFFFFFFFFFFFFFL ^ l;
    }

    public static void flush() {
    }

    public static void main(String[] stringArray) {
        String string = new String("This is Fred");
        try {
            Traces.initializeTraces(stringArray);
            Traces.logError(string, "Test Message 1");
            Traces.logWarning(string, "Test Message 2");
            Traces.logInformation(string, "Test Message 3");
            Traces.logException(new NullPointerException());
            Traces.flush();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static {
        maxLogSize = 1000000;
        TRACE_STRINGS = new String[]{"SNMP", "Platform", "Polling", "JPM Database", "Status Updates", "Definition Modificaitons", "Resource Activation", "8250/60/65 JMA", "8250/60/65 Decoder", "8250/60/65 Bridge", "8229 JMA", "8230 JMA", "8238 JMA", "8285 JMA", "8275 - Models 113,217,225", "8275 - Models 3xx", "8275 - Models 4xx", "8271 - Models 524,612,624,712, Exx,Fxx", "8260 - Switching Modules JMA", "8281 - ATM LAN Bridge", "8282 - ATM Concentrator", "2212 - Access Utility", "2210 - Ethernet Stackable Hub", "2216 - Multiaccess Connector", "8224 - Ethernet Stackable Hub", "XXXX - Free Slot", "8237 - Ethernet Stackable Hub", "8239 - Token Ring Stackable Hub", "8245 - Hub", "XXXX - Free Slot", "8271k - Ethernet Lan Switch", "8272 - Token-Ring LAN Switch"};
    }
}

